<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;
use App\Modules\LeadBookingTour\Infraestructure\MysqlLeadBookingTourRepository;

$router->post(
    '/leadBookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourInsertController@__invoke'
    ]
);

$router->put(
    '/leadBookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBookingTour/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourDeleteController@__invoke'
    ]
);

$router->get(
    '/leadBookingTour/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourIndexController@__invoke'
    ]
);

$router->get(
    '/leadBooking/{Id_LeadBooking:[0-9]*}/leadBookingTour/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTour\\LeadBookingTourListController@__invoke'
    ]
);

$app->bind(LeadBookingTourRepository::class, fn($app) => $app->make(MysqlLeadBookingTourRepository::class));
