<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class AdminMother {
    
    public static function build1($idTypeDocument, $idAdminRole, $idCountry = null, $idState = null, $idCity = null, $id = 1) {
        $faker = Factory::create();
        $idCountry = $idCountry !== null ? $idCountry : CountryMother::push1()['Id_Country'];
        $idState = $idState !== null ? $idState : StateMother::push1($idCountry)['Id_State'];
        $idCity = $idCity !== null ? $idCity : CityMother::push1($idState)['Id_City'];
        $Admin_NoDocument = Util::generateInt(rand(5, 19));
        return [
            'Id_Admin'                  => $id,
            'Admin_Name'                => Str::title($faker->text(rand(5, 100))),
            'Admin_LastName'            => Str::title($faker->text(rand(5, 100))),
            'Admin_Abrv'                => Str::upper(Util::generateString(4)),
            'Admin_NoDocument'          => $Admin_NoDocument,
            'Admin_Password'            => sha1('123123'),
            'Admin_Email'               => $faker->email,
            'Admin_Address'             => $faker->text(rand(5, 250)),
            'Admin_Phone'               => $faker->phoneNumber,
            'Admin_Color'               => $faker->hexColor,
            'Admin_Status'              => $faker->randomElement([2]),
            'Id_TypeDocument'           => $idTypeDocument,
            'Id_AdminRole'              => $idAdminRole,
            'Id_Country'                => $idCountry,
            'Id_State'                  => $idState,
            'Id_City'                   => $idCity,
        ];
    }
    public static function push1($idTypeDocument, $idAdminRole, $idCountry = null, $idState = null, $idCity = null, $id = 1) {
        return self::push(self::build1($idTypeDocument, $idAdminRole, $idCountry, $idState, $idCity, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_admin_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['Admin_Name'],
            $object['Admin_LastName'],
            $object['Admin_Abrv'],
            $object['Admin_NoDocument'],
            $object['Admin_Email'],
            $object['Admin_Address'],
            $object['Admin_Phone'],
            $object['Admin_Color'],
            $object['Admin_Status'],
            $object['Id_TypeDocument'],
            $object['Id_AdminRole'],
            $object['Id_Country'],
            $object['Id_State'],
            $object['Id_City'],
        ]);
        $object['Id_Admin'] = $response[0]->Response_Id;
        return $object;
    }

}