<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class AdminSessionMother
{

    public static $admin;
    
    public static function build1($id = 1)
    {
        return [
            'Id_AdminSession'           => $id,
            'AdminSession_IP'           => '127.0.0.1',
            'AdminSession_DateStart'    => date('Y-m-d H:i:s'),
            'AdminSession_DateEnd'      => date('Y-m-d H:i:s'),
            'AdminSession_Token'        => '',
            'AdminSession_Status'       => 2,
            'Id_Admin'                  => 1,
        ];
    }

    public static function push1($Admin_Email, $Admin_Password, $id = 1)
    {
        return self::push(self::build1($id), $Admin_Email, $Admin_Password);
    }

    private static function push($object, $Admin_Email, $Admin_Password)
    {
        $response = DB::select("CALL `sp_admin_session_insert` (?,?,?)", [
            $Admin_Email,
            $Admin_Password,
            $object['AdminSession_IP'],
        ]);
        
        $object['AdminSession_Token'] = $response[0]->Response_Token;
        $object['Id_AdminSession'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        TC::clearTables(TC::language, TC::admin_role, TC::type_document, TC::type_document_transl, TC::country, TC::state, TC::city, TC::ADMIN, TC::admin_session, TC::credential);
        CredentialMother::clear();
    }

    public static function createSession()
    {
        CredentialMother::insert(CredentialMother::Config_AccessTokenMinutes);
        $typeDocument = TypeDocumentMother::push1();
        $adminRole = AdminRoleMother::push1();
        $country = CountryMother::push1();
        $state = StateMother::push1($country['Id_Country']);
        $city = CityMother::push1($state['Id_State']);

        $admin = AdminMother::push1(
            $typeDocument['Id_TypeDocument'],
            $adminRole['Id_AdminRole'],
            $country['Id_Country'],
            $state['Id_State'],
            $city['Id_City']
        );
        self::$admin = $admin;
        return AdminSessionMother::push1($admin['Admin_Email'], $admin['Admin_NoDocument']);
    }

    public static function token($session)
    {
        return ['Token' => $session['AdminSession_Token'], 'Url' => $session['AdminSession_Token']];
    }
}
