<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class CountryMother {
    
    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_Country'			=> $id,            
            'Country_Code'		    => Util::generateString(3),
            'Country_Name'		    => $faker->text(rand(5, 250)),
            'Country_Status'		=> $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_country_insert` (?,?,?)", [
            $object['Country_Code'],
            $object['Country_Name'],
            $object['Country_Status'],
        ])[0];
        $object['Id_Country'] = $response->Response_Id;
        return $object;
    }

    public static function tablesToClear() {
        return [ TC::country ];
    }

}