<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ExternalMother
{
    
    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_External' => $id,
            'External_Name' => $faker->text(rand(5, 250)),
            'External_Abrv' => Util::generateString(4),
            'External_Asset' => $faker->text(rand(5, 100)),
            'External_Lock' => $faker->randomElement([1, 2]),
            'External_Status' => $faker->randomElement([1, 2]),
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_external_insert`(?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['External_Name'],
            $object['External_Abrv'],
            $object['External_Asset'],
            $object['External_Lock'],
            $object['External_Status']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_External'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::EXTERNAL ];
    }
}
