<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ExternalUserPassengerMother
{
    
    public static function build1($idPassenger, $idExternalUser = null, $id = 1)
    {
        $idExternalUser = $idExternalUser ?? ExternalUserMother::push1()['Id_ExternalUser'];
        $faker = Factory::create();
        return [
            'Id_ExternalUserPassenger' => $id,
            'ExternalUserPassenger_Status' => $faker->randomElement([1, 2]),
            'Id_ExternalUser' => $idExternalUser,
            'Id_Passenger' => $idPassenger
        ];
    }

    public static function push1($idPassenger, $idExternalUser = null, $id = 1)
    {
        return self::push(self::build1($idPassenger, $idExternalUser, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_external_user_passenger_insert`(?,?,?,@sts,@cod,@msg,@id)", [
            $object['ExternalUserPassenger_Status'],
            $object['Id_ExternalUser'],
            $object['Id_Passenger']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_ExternalUserPassenger'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::EXTERNAL_USER_PASSENGER],
            ExternalMother::tablesToClear(),
            ExternalUserMother::tablesToClear(),
            [
                TC::passenger,
                TC::booking,
                TC::booking_relationship,
                TC::booking_referred_from,
                TC::language,
                TC::user,
                TC::user_country,
                TC::type_rate,
                TC::type_rate_transl,
                TC::type_document,
                TC::type_document_transl,
            ]
        );
    }
}
