<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class GroupProviderMother {

    public static function build1($idGroup, $idProvider, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_GroupProvider' => $id,
            'GroupProvider_Type' => $faker->randomElement([1, 2]),
            'Id_Group' => $idGroup,
            'Id_Provider' => $idProvider
        ];
    }

    public static function push1($idGroup, $idProvider, $id = 1) {
        return self::push(self::build1($idGroup, $idProvider, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_group_provider_insert` (?,?,?)", [
            $object['GroupProvider_Type'],
            $object['Id_Group'],
            $object['Id_Provider'],
        ]);
        $object['Id_GroupProvider'] = $response[0]->Response_Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TC::group_provider,
            TC::group,
            TC::tour,
            ...ProviderMother::tablesToClear()
        ];
    }

}