<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class LeadBookingServicePassengerMother
{
    public static function build1($Id_LeadBookingService, $Id_LeadBookingTourPassenger, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_LeadBookingServicePassenger' => $id,
            'LeadBookingServicePassenger_Status' => $faker->randomElement([1, 2]),
            'Id_LeadBookingService' => $Id_LeadBookingService,
            'Id_LeadBookingTourPassenger' => $Id_LeadBookingTourPassenger
        ];
    }

    public static function push1($Id_LeadBookingService, $Id_LeadBookingTourPassenger, $id = 1)
    {
        return self::push(self::build1($Id_LeadBookingService, $Id_LeadBookingTourPassenger, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_lead_booking_service_passenger_insert`(?,?,?,@sts,@cod,@msg,@id)", [
            $object['LeadBookingServicePassenger_Status'],
            $object['Id_LeadBookingService'],
            $object['Id_LeadBookingTourPassenger']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_LeadBookingServicePassenger'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::LEAD_BOOKING_SERVICE_PASSENGER],
            LeadBookingServiceMother::tablesToClear(),
            LeadBookingTourPassengerMother::tablesToClear(),
        );
    }
}
