<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class LeadBookingTourMother
{
    public static function build1($Id_LeadBooking, $Id_Package = null, $Id_Tour = null, $id = 1)
    {
        $faker = Factory::create();
        $Id_Package = $Id_Package ?? PackageMother::push1()['Id_Package'];
        $Id_Tour = $Id_Tour ?? TourMother::push1()['Id_Tour'];
        return [
            'Id_LeadBookingTour' => $id,
            'LeadBookingTour_DateStart' => date('Y-m-d'),
            'LeadBookingTour_PickUp' => date('H:m:s'),
            'LeadBookingTour_Type' => $faker->randomElement([1, 2]),
            'LeadBookingTour_NoPax' => 0,
            'LeadBookingTour_Group' => 0,
            'LeadBookingTour_Status' => $faker->randomElement([1, 2]),
            'Id_LeadBooking' => $Id_LeadBooking,
            'Id_Package' => $Id_Package,
            'Id_Tour' => $Id_Tour
        ];
    }

    public static function push1($Id_LeadBooking, $Id_Package = null, $Id_Tour = null, $id = 1)
    {
        return self::push(self::build1($Id_LeadBooking, $Id_Package, $Id_Tour, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_lead_booking_tour_insert`(?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['LeadBookingTour_DateStart'],
            $object['LeadBookingTour_PickUp'],
            $object['LeadBookingTour_Type'],
            $object['LeadBookingTour_NoPax'],
            $object['LeadBookingTour_Group'],
            $object['LeadBookingTour_Status'],
            $object['Id_LeadBooking'],
            $object['Id_Package'],
            $object['Id_Tour']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_LeadBookingTour'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::LEAD_BOOKING],
            [TC::package, TC::package_transl],
            TourMother::clear(),
            LeadBookingMother::tablesToClear()
        );
    }
}
