<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class QuestionMother
{
    
    public static function build1($idTypeProvider = null, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_Question'           => $id,
            'Question_Name'         => Str::title($faker->text(rand(5, 250))),
            'Question_Abrv'         => Str::upper(Util::generateString(4)),
            'Question_Type'         => $faker->randomElement([1, 2, 3, 4, 5, 6]),
            'Question_Values'       => json_encode(['asdasd', 'asdadsad', 'qwezxcqwe']),
            'Question_Weight'       => rand(1, 100) / 50,
            'Question_General'      => $faker->randomElement([1, 2]),
            'Question_Status'       => $faker->randomElement([1, 2]),
            'Id_TypeProvider'       => $idTypeProvider ?? TypeProviderMother::push1()['Id_TypeProvider']
        ];
    }

    public static function push1($idTypeProvider = null, $id = 1)
    {
        return self::push(self::build1($idTypeProvider, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_question_insert` (?,?,?,?,?,?,?,?)", [
            $object['Question_Name'],
            $object['Question_Abrv'],
            $object['Question_Type'],
            $object['Question_Values'],
            $object['Question_Weight'],
            $object['Question_General'],
            $object['Id_TypeProvider'],
            $object['Question_Status']
        ]);
        $object['Id_Question'] = $response[0]->Response_Id;
        return $object;
    }
}
