<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\DBRealTestSupport\TableCreation as TC;

class TourMother
{
    
    public static function build1(
        $idCategoryTour = null,
        $idTypeTour = null,
        $idCountry = null,
        $idState = null,
        $idCity = null,
        $id = 1
    ) {
        $faker = Factory::create();
        $country = $idCountry ?? CountryMother::push1()['Id_Country'];
        $state = $idState ?? StateMother::push1($country)['Id_State'];
        $city = $idCity ?? CityMother::push1($state)['Id_City'];
        return [
            'Id_Tour'                   => $id,
            'Tour_Code'                 => Str::upper($faker->text(rand(5, 50))),
            'Tour_Name'                 => Str::title($faker->text(rand(5, 250))),
            'Tour_UrlThumbnail'         => $faker->text(rand(5, 500)),
            'Tour_Duration'             => rand(1, 10),
            'Tour_MinPax'               => rand(0, 10),
            'Tour_Availability'         => rand(5, 10),
            'Tour_AvailabilityStatus'   => $faker->randomElement([1, 2]),
            'Tour_Anticipation'         => rand(0, 10),
            'Tour_AnticipationType'     => $faker->randomElement([1, 2, 3]),
            'Tour_Color'                => $faker->text(rand(5, 10)),
            'Tour_Score'                => 0,
            'Tour_Status'               => $faker->randomElement([1, 2]),
            'Id_CategoryTour'           => $idCategoryTour ?? CategoryTourMother::push1()['Id_CategoryTour'],
            'Id_TypeTour'               => $idTypeTour ?? TypeTourMother::push1()['Id_TypeTour'],
            'Id_Country'                => $country,
            'Id_State'                  => $state,
            'Id_City'                   => $city
        ];
    }

    public static function push1(
        $idCategoryTour = null,
        $idTypeTour = null,
        $idCountry = null,
        $idState = null,
        $idCity = null,
        $id = 1
    ) {
        return self::push(self::build1($idCategoryTour, $idTypeTour, $idCountry, $idState, $idCity, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_tour_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['Tour_Code'],
            $object['Tour_Name'],
            $object['Tour_UrlThumbnail'],
            $object['Tour_Duration'],
            $object['Tour_MinPax'],
            $object['Tour_Availability'],
            $object['Tour_AvailabilityStatus'],
            $object['Tour_Anticipation'],
            $object['Tour_AnticipationType'],
            $object['Tour_Color'],
            $object['Tour_Status'],
            $object['Id_CategoryTour'],
            $object['Id_TypeTour'],
            $object['Id_Country'],
            $object['Id_State'],
            $object['Id_City'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_Tour'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function clear()
    {
        return [ TC::category_tour, TC::type_tour, TC::country, TC::state, TC::city, TC::tour];
    }
}
