<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;

class TypeItemMother {
    
    public static function build1($id = 1) {
        $faker = \Faker\Factory::create();
        return [
            'Id_TypeItem' => $id,
            'TypeItem_Name' => $faker->text(rand(5, 250)),
            'TypeItem_Abrv' => Util::generateString(4),
            'TypeItem_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_type_item_insert` (?,?,?)", [
            $object['TypeItem_Name'],
            $object['TypeItem_Abrv'],
            $object['TypeItem_Status']
        ]);
        $object['Id_TypeItem'] = $response[0]->Response_Id;
        return $object;
    }

}