<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class CashMovementMother {
    
    public static function build1($id = 1, $invoices = [ [ 'Amount' => '150.00', 'Id_Invoice' => 1 ] ]) {
        return [
            'Id_CashMovement' => $id,
            'CashMovement_DatePayment'		=> date('Y-m-d H:i:s'),
            'CashMovement_Amount'			=> '150.00',
            'CashMovement_Currency'			=> 'USD',
            'CashMovement_Name'				=> 'Jesús',
            'CashMovement_LastName'			=> 'Curi',
            'CashMovement_Email'			=> 'jesuscuri13@gmail.com',
            'CashMovement_Country'			=> 'Per',
            'CashMovement_City'				=> 'Cus',
            'CashMovement_Address'			=> 'Per-Cus',
            'CashMovement_Phone'			=> '987654321',
            'CashMovement_ReceiptNumber'	=> '123456789',
            'CashMovement_CardLast'			=> '-',
            'CashMovement_CardNumber'		=> '-',
            'CashMovement_CardBrand'		=> '-',
            'CashMovement_CardType'			=> '-',
            'CashMovement_CardIssuer'		=> '-',
            'CashMovement_Remark'			=> '-',
            'Id_TypePayment'				=> 1,
            'Invoices'						=> json_encode($invoices)
        ];
    }

    public static function push1($id, $tester, $token) {
        return self::push(self::build1($id), $tester, $token);
    }

    
    
    public static function buildClient($id = 1, $invoices = [ [ 'Amount' => '105.00', 'Id_Invoice' => 1 ] ]) {
        return [
            'Id_CashMovement' => $id,
            'CashMovement_DatePayment'		=> date('Y-m-d H:i:s'),
            'CashMovement_Amount'			=> '105.00',
            'CashMovement_Currency'			=> 'USD',
            'CashMovement_Name'				=> 'Jesús',
            'CashMovement_LastName'			=> 'Curi',
            'CashMovement_Email'			=> 'jesuscuri13@gmail.com',
            'CashMovement_Country'			=> 'Per',
            'CashMovement_City'				=> 'Cus',
            'CashMovement_Address'			=> 'Per-Cus',
            'CashMovement_Phone'			=> '987654321',
            'CashMovement_ReceiptNumber'	=> '123456789',
            'CashMovement_CardLast'			=> '-',
            'CashMovement_CardNumber'		=> '-',
            'CashMovement_CardBrand'		=> '-',
            'CashMovement_CardType'			=> '-',
            'CashMovement_CardIssuer'		=> '-',
            'CashMovement_Remark'			=> '-',
            'Id_TypePayment'				=> 1,
            'Invoices'						=> json_encode($invoices)
        ];
    }
    
    public static function build2($id = 1, $invoices = [ [ 'Amount' => '400.00', 'Id_Invoice' => 1 ] ]) {
        return [
            'Id_CashMovement' => $id,
            'CashMovement_DatePayment'		=> date('Y-m-d H:i:s'),
            'CashMovement_Amount'			=> '400.00',
            'CashMovement_Currency'			=> 'USD',
            'CashMovement_Name'				=> 'Jesús',
            'CashMovement_LastName'			=> 'Curi',
            'CashMovement_Email'			=> 'jesuscuri13@gmail.com',
            'CashMovement_Country'			=> 'Per',
            'CashMovement_City'				=> 'Cus',
            'CashMovement_Address'			=> 'Per-Cus',
            'CashMovement_Phone'			=> '987654321',
            'CashMovement_ReceiptNumber'	=> '123456789',
            'CashMovement_CardLast'			=> '-',
            'CashMovement_CardNumber'		=> '-',
            'CashMovement_CardBrand'		=> '-',
            'CashMovement_CardType'			=> '-',
            'CashMovement_CardIssuer'		=> '-',
            'CashMovement_Remark'			=> '-',
            'Id_TypePayment'				=> 1,
            'Invoices'						=> json_encode($invoices)
        ];
    }

    public static function push2($id, $tester, $token) {
        return self::push(self::build2($id), $tester, $token);
    }

    private static function push($object, $tester, $token) {
        $tester->post('/owner/cashMovement', $object,
        [
            'Token' => $token,
            'Url' => $token
        ]);
        return $object;
    }

}