<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class PackageFeeMother {
    
    public static function buildFixed1($id = 1, $idPackage = 1, $packageAmount = '100.00') {
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => $packageAmount,
            'PackageFee_Full' => 2,
            'PackageFee_Type' => 2,
            'Id_Package' => $idPackage
        ];
    }
    
    public static function buildShared1($id = 1, $idPackage = 1, $idTypeRate = 1) {
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => '100.00',
            'PackageFee_Full' => 2,
            'PackageFee_Type' => 1,
            'Id_Package' => $idPackage
        ];
    }

    public static function pushFixed1($id = 1, $idPackage = 1, $packageAmount = '100.00') {
        return self::push(self::buildFixed1($id, $idPackage, $packageAmount));
    }

    public static function pushShared1($id = 1, $idPackage = 1, $idTypeRate = 1) {
        return self::push(self::buildShared1($id, $idPackage, $idTypeRate));
    }

    
    public static function buildShared2($id = 1, $idPackage = 1, $PackageFee_Full = 2) {
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => '50.00',
            'PackageFee_Full' => 2,
            'PackageFee_Type' => 1,
            'Id_Package' => $idPackage
        ];
    }

    public static function pushShared2($id = 1, $idPackage = 1, $PackageFee_Full = 2) {
        return self::push(self::buildShared2($id, $idPackage, $PackageFee_Full));
    }

    private static function push($object) {
        DB::select("CALL `sp_package_fee_insert` (?,?,?,?)", [
            $object['PackageFee_Amount'],
            $object['PackageFee_Full'],
            $object['PackageFee_Type'],
            $object['Id_Package']
        ]);
        return $object;
    }

}