<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;


class c_Flight_Passenger extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Flight Passenger";
	}

	public function Insert(Request $Request){
		$oResponse  = array();
        $oValParams = array(    'Id_Flight'			=> 'required|int',
								'Id_Passenger'		=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
            $oParam = array(    $Request->input("Id_Flight"),
								$Request->input("Id_Passenger")
							);
			$oData = DB::select('call sp_flight_passenger_insert(?,?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_FlightPassenger'	=> 'required|int',
								'Id_Flight'			=> 'required|int',
								'Id_Passenger'		=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    $Request->input("Id_FlightPassenger"),
								$Request->input("Id_Flight"),
								$Request->input("Id_Passenger")
							);
			$oData = DB::select('call sp_flight_passenger_update(?,?,?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_flight_passenger_delete(?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_flight_passenger_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_Flight){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Id_Flight, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id );
			$oData  = DB::select('call sp_flight_passenger_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}