<?php
namespace App\Http\Controllers\Owner\Booking;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Booking\Application\BookingReporter;
use App\Modules\Booking\Domain\BookingStatus;
use App\Modules\Booking\Domain\BookingType;
use App\Modules\Booking\Domain\ReportExcelRequirements;
use App\Modules\Booking\Domain\UserType;
use App\Modules\Booking\Infraestructure\BookingValidators;
use App\Modules\Booking\Infraestructure\MysqlBookingRepository;
use App\Providers\ExcelBookingReport\ExcelBookingReport;

final class BookingExportToExcelController extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'Booking';
    }

    public function __invoke(Request $Request)
    {
        $oResponse = ParamsValidator::Validate_Request($Request, BookingValidators::EXPORT_TO_EXCEL, $this->oDomain);
        if ($oResponse["Response_Code"] != 200) {
            return ResponseBuilder::Response($oResponse);
        }

        $data = (new BookingReporter(new MysqlBookingRepository))->__invoke(
            new ReportExcelRequirements(
                $Request->input('Query'),
                $Request->input('DateStart'),
                $Request->input('DateEnd'),
                new BookingStatus($Request->input('Booking_Status')),
                new UserType($Request->input('User_Type')),
                new BookingType($Request->input('Booking_Type'))
            )
        );
        (new ExcelBookingReport())->exportToExcel($data);
    }
}
