<?php
namespace App\Http\Controllers\Owner\Booking;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Booking\Infraestructure\MysqlBookingReceiptRepository;
use App\Modules\Booking\Application\BookingReceiptChanger;
use App\Modules\Booking\Domain\ReceiptBooking;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Infraestructure\Validators\BookingReceiptValidators;
use App\Modules\Booking\Domain\BookingReceipt;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

final class c_Receipt extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = 'Booking';
        $this->history = new HistoryData(HistoryTables::booking);
    }

    public function __invoke(Request $Request)
    {
        
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, BookingReceiptValidators::basic);
        $this->history->obtainOld($Request->input('Id_Booking'));
        
        $response = (new BookingReceiptChanger(new MysqlBookingReceiptRepository))->__invoke(
            new ReceiptBooking(
                new IdBooking($Request->input('Id_Booking')),
                new BookingReceipt($Request->input('Booking_Receipt'))
            )
        );
        $this->history->update(
            $Request->input('Id_Booking'),
            $this->history->oldValue,
            [$Request->all()],
            $Request
        );

        return ResponseBuilder::Response($response);
    }
}
