<?php
namespace App\Http\Controllers\Owner\ExternalReview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;
use App\Modules\External\Domain\IdExternal;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ExternalReview\Application\ExternalReviewUpdater;
use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\ExternalReview\Domain\ExternalReviewDateReview;
use App\Modules\ExternalReview\Domain\ExternalReviewRoute;
use App\Modules\ExternalReview\Domain\ExternalReviewScore;
use App\Modules\ExternalReview\Domain\ExternalReviewStatus;
use App\Modules\ExternalReview\Domain\ExternalReviewTitle;
use App\Modules\ExternalReview\Domain\ExternalReviewType;
use App\Modules\ExternalReview\Domain\ExternalReviewValue;
use App\Modules\ExternalReview\Domain\UpdateExternalReview;
use App\Modules\ExternalReview\Infraestructure\MysqlExternalReviewRepository;
use App\Modules\ExternalReview\Infraestructure\ExternalReviewValidators;
use App\Modules\ExternalReviewProvider\Application\ExternalReviewProviderInserter;
use App\Modules\ExternalReviewProvider\Application\ExternalReviewProviderUpdater;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProviderStatus;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProviderType;
use App\Modules\ExternalReviewProvider\Domain\IdExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Infraestructure\MysqlExternalReviewProviderRepository;
use App\Modules\ExternalUser\Application\ExternalUserInsertOrUpdater;
use App\Modules\ExternalUser\Domain\EasyExternalUser;
use App\Modules\ExternalUser\Domain\ExternalUserLastName;
use App\Modules\ExternalUser\Domain\ExternalUserName;
use App\Modules\ExternalUser\Domain\ExternalUserNickName;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\ExternalUser\Infraestructure\MysqlExternalUserRepository;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Language\Domain\IdLanguage;

class ExternalReviewUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;
    private HistoryData $externalReviewProviderHistory;

    public function __construct()
    {
        $this->domain = "ExternalReview";
        $this->history = new HistoryData(HistoryTables::EXTERNAL_REVIEW);
        $this->externalReviewProviderHistory = new HistoryData(HistoryTables::EXTERNAL_REVIEW_PROVIDER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ExternalReviewValidators::UPDATE);
        $object = [
            'ExternalReviewProvider' => json_decode($request->input('ExternalReviewProvider'), true)
        ];
        (new LaravelValidator())->validate($object, $this->domain, ExternalReviewValidators::UPDATE_GROUP_PROVIDER);

        $this->history->obtainOld($request->input("Id_ExternalReview"));

        $idExternalUser = (new ExternalUserInsertOrUpdater(new MysqlExternalUserRepository))
            ->__invoke(
                new EasyExternalUser(
                    new ExternalUserName($request->input('ExternalUser_Name')),
                    new ExternalUserLastName(''),
                    new ExternalUserNickName($request->input('ExternalUser_NickName')),
                    new IdExternalUser($request->input('Id_ExternalUser')),
                ),
                new IdExternal($request->input('Id_External')),
            );

        $response = (new ExternalReviewUpdater(new MysqlExternalReviewRepository()))
            ->__invoke(new UpdateExternalReview(
                new ExternalReviewDateReview($request->input('ExternalReview_DateReview')),
                new ExternalReviewRoute($request->input('ExternalReview_Route')),
                new ExternalReviewTitle($request->input('ExternalReview_Title')),
                new ExternalReviewValue($request->input('ExternalReview_Value')),
                new ExternalReviewScore($request->input('ExternalReview_Score')),
                new ExternalReviewType($request->input('ExternalReview_Type')),
                new ExternalReviewStatus($request->input('ExternalReview_Status')),
                $idExternalUser,
                new IdExternalUserPassenger($request->input('Id_ExternalUserPassenger')),
                new IdGroupPassenger($request->input('Id_GroupPassenger')),
                new IdBookingRelationship($request->input('Id_BookingRelationship')),
                new IdLanguage($request->input('Id_Language')),
                new IdExternal($request->input('Id_External')),
                new IdExternalReview($request->input('Id_ExternalReview_Parent')),
                new IdExternalReview($request->input('Id_ExternalReview')),
            ));

        $this->history->updateBasic($request->input("Id_ExternalReview"), $request);

        foreach ($object['ExternalReviewProvider'] as $erp) {
            if ($erp['Id_ExternalReviewProvider']) {
                $this->externalReviewProviderHistory->obtainOld($request->input("Id_ExternalReviewProvider"));
                (new ExternalReviewProviderUpdater(new MysqlExternalReviewProviderRepository()))
                    ->__invoke(new ExternalReviewProvider(
                        new ExternalReviewProviderType($erp['ExternalReviewProvider_Type']),
                        new ExternalReviewProviderStatus($erp['ExternalReviewProvider_Status']),
                        new IdExternalReview($erp['Id_ExternalReview']),
                        new IdGroupProvider($erp['Id_GroupProvider']),
                        new IdExternalReviewProvider($erp['Id_ExternalReviewProvider']),
                    ));
                $this->externalReviewProviderHistory->updateBasic($erp['Id_ExternalReviewProvider'], $request);
            } else {
                (new ExternalReviewProviderInserter(new MysqlExternalReviewProviderRepository()))
                ->__invoke(new ExternalReviewProvider(
                    new ExternalReviewProviderType($erp['ExternalReviewProvider_Type']),
                    new ExternalReviewProviderStatus(ExternalReviewProviderStatus::ACTIVE),
                    new IdExternalReview($request->input('Id_ExternalReview')),
                    new IdGroupProvider($erp['Id_GroupProvider']),
                ));
                $this->externalReviewProviderHistory->insertBasic($request, true);
            }
        }

        return ResponseBuilder::Response($response);
    }
}
