<?php
namespace App\Http\Controllers\Owner\ExternalUser;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\External\Domain\IdExternal;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ExternalUser\Application\ExternalUserInserter;
use App\Modules\ExternalUser\Domain\ExternalUser;
use App\Modules\ExternalUser\Domain\ExternalUserGender;
use App\Modules\ExternalUser\Domain\ExternalUserLastName;
use App\Modules\ExternalUser\Domain\ExternalUserName;
use App\Modules\ExternalUser\Domain\ExternalUserNickName;
use App\Modules\ExternalUser\Domain\ExternalUserStatus;
use App\Modules\ExternalUser\Infraestructure\MysqlExternalUserRepository;
use App\Modules\ExternalUser\Infraestructure\ExternalUserValidators;

class ExternalUserInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->domain = "ExternalUser";
        $this->history = new HistoryData(HistoryTables::EXTERNAL_USER);
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator())->validate($Request->all(), $this->domain, ExternalUserValidators::INSERT);

        $response = (new ExternalUserInserter(new MysqlExternalUserRepository()))
            ->__invoke(new ExternalUser(
                new ExternalUserName($Request->input('ExternalUser_Name')),
                new ExternalUserLastName($Request->input('ExternalUser_LastName')),
                new ExternalUserNickName($Request->input('ExternalUser_NickName')),
                new ExternalUserGender($Request->input('ExternalUser_Gender')),
                new ExternalUserStatus($Request->input('ExternalUser_Status')),
                new IdExternal($Request->input('Id_External')),
            ));
        $this->history->insertBasic($Request, $response['Response_Data']['Id']);

        return ResponseBuilder::Response($response);
    }
}
