<?php
namespace App\Http\Controllers\Owner\ExternalUserPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ExternalUserPassenger\Application\ExternalUserPassengerUpdater;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\ExternalUserPassenger\Domain\ExternalUserPassenger;
use App\Modules\ExternalUserPassenger\Domain\ExternalUserPassengerStatus;
use App\Modules\ExternalUserPassenger\Infraestructure\MysqlExternalUserPassengerRepository;
use App\Modules\ExternalUserPassenger\Infraestructure\ExternalUserPassengerValidators;
use App\Modules\Passenger\Domain\IdPassenger;

class ExternalUserPassengerUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->domain = "ExternalUserPassenger";
        $this->history = new HistoryData(HistoryTables::EXTERNAL_USER_PASSENGER);
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator())->validate($Request->all(), $this->domain, ExternalUserPassengerValidators::INSERT);

        $this->history->obtainOld($Request->input("Id_ExternalUserPassenger"));

        $response = (new ExternalUserPassengerUpdater(new MysqlExternalUserPassengerRepository()))
            ->__invoke(new ExternalUserPassenger(
                new ExternalUserPassengerStatus($Request->input('ExternalUserPassenger_Status')),
                new IdExternalUser($Request->input('Id_ExternalUser')),
                new IdPassenger($Request->input('Id_Passenger')),
                new IdExternalUserPassenger($Request->input('Id_ExternalUserPassenger'))
            ));

        $this->history->updateBasic($Request->input("Id_ExternalUserPassenger"), $Request);

        return ResponseBuilder::Response($response);
    }
}
