<?php
namespace App\Http\Controllers\Owner\Group;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Group\Application\GroupProviderPassengerFinder;
use App\Modules\Group\Infraestructure\GroupValidators;
use App\Modules\Group\Infraestructure\MysqlGroupProviderPassengerRepository;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class ProviderPassenger extends Controller
{
    public function __construct()
    {
        $this->oDomain = 'Group';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, GroupValidators::PROVIDER_PASSENGER_LIST);
        $response = (new GroupProviderPassengerFinder(new MysqlGroupProviderPassengerRepository))->__invoke(
            new IdProvider($request->input('Id_Provider')),
            new DateStart($request->input('DateStart')),
            new DateEnd($request->input('DateEnd')),
            $request->input('Search'),
        );
        return ResponseBuilder::Response($response);
    }
}
