<?php
namespace App\Http\Controllers\Owner\LeadBookingTour;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBookingTour\Application\Index\LeadBookingTourIndexerQuery;
use App\Modules\LeadBookingTour\Application\Index\LeadBookingTourIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var LeadBookingTourIndexerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
