<?php
namespace App\Http\Controllers\Owner\LeadPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadPassenger\Application\Delete\LeadPassengerDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadPassengerDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadPassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_PASSENGER);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var LeadPassengerDeleterResponse $response */
        $response = $this->queryBus->ask(new LeadPassengerDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
