<?php
namespace App\Http\Controllers\Owner\ReviewNotification;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ReviewNotification\Application\Delete\ReviewNotificationDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ReviewNotificationDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ReviewNotification";
        $this->history = new HistoryData(HistoryTables::REVIEW_NOTIFICATION);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var ReviewNotificationDeleterResponse $response */
        $response = $this->queryBus->ask(new ReviewNotificationDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
