<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class TypeProvider extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;


    public function __construct()
    {
        $this->oDomain = "Type Provider";
        $this->history = new HistoryData(HistoryTables::type_provider);
    }

    public function insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'TypeProvider_Name'     => 'required|string|max:250',
                                'TypeProvider_Abrv'     => 'required|string|max:4',
                                'TypeProvider_Endorser' => 'required|int',
                                'TypeProvider_Status'   => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            #region INSERTA DATOS
            $oParam = array(    Str::title(trim($Request->input("TypeProvider_Name"))),
                                Str::upper(trim($Request->input("TypeProvider_Abrv"))),
                                $Request->input("TypeProvider_Endorser"),
                                $Request->input("TypeProvider_Status")
                            );
            $oData = DB::select('call sp_type_provider_insert(?,?,?,?)', $oParam);

            #endregion
            $data = null;
            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->insertBasic($Request);
                $data = [ 'Id' => $oData[0]->Response_Id ];
                #endregion
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_TypeProvider'       => 'required|int',
                                'TypeProvider_Name'     => 'required|string|max:250',
                                'TypeProvider_Abrv'     => 'required|string|max:4',
                                'TypeProvider_Endorser' => 'required|int',
                                'TypeProvider_Status'   => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_TypeProvider'));
            #endregion

            #region ACTUALIZA DATOS
            $oParam = [
                $Request->input("Id_TypeProvider"),
                Str::title($Request->input("TypeProvider_Name")),
                Str::upper($Request->input("TypeProvider_Abrv")),
                $Request->input("TypeProvider_Endorser"),
                $Request->input("TypeProvider_Status")
            ];

            $oData = DB::select('call sp_type_provider_update(?,?,?,?,?)', $oParam);
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic($Request->input("Id_TypeProvider"), $Request);
                #endregion
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }
        return ResponseBuilder::Response($oResponse);
    }

    public function delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            #region ELIMINA DATOS

            $oParam = array( $Id );
            $oData  = DB::select('call sp_type_provider_delete(?)', $oParam);

            #endregion

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic($Id, $Request);
                #endregion
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_type_provider_index(?)', $oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function list(Request $Request, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_type_provider_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function selector(Request $Request, $Id)
    {
        if (is_numeric($Id)) {
            return self::index($Request, $Id);
        } else {
            return self::list($Request, $Id);
        }
    }
}
