<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformationPassenger\Infraestructure\MysqlPaxInformationPassengerRepository;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsertCommandHandler;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsert;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsertCommand;
use App\Modules\PaxInformationPassenger\Application\PaxInformationPassengerDeleter;
use App\Modules\PaxInformationPassenger\Application\PaxInformationPassengerFinder;
use App\Modules\PaxInformationPassenger\Application\PaxInformationPassengerIndexer;
use App\Modules\PaxInformationPassenger\Application\PaxInformationPassengerUpdater;
use App\Modules\PaxInformationPassenger\Domain\IdPaxInformationPassenger;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerDescription;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerStatus;
use App\Modules\PaxInformationPassenger\Domain\UpdatePaxInformationPassenger;
use App\Modules\PaxInformationPassenger\Infraestructure\PaxInformationPassengerValidators;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class c_PaxInformationPassenger extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "PaxInformationPassenger";
        $this->history = new HistoryData(HistoryTables::pax_information);
    }

    public function Insert(Request $Request)
    {

        (new LaravelValidator)->validate($Request->all(), $this->oDomain, PaxInformationPassengerValidators::INSERT);
        $oResponse = (new PaxInformationPassengerInsertCommandHandler(
            new PaxInformationPassengerInsert(new MysqlPaxInformationPassengerRepository)
        ))->__invoke(new PaxInformationPassengerInsertCommand(
            $Request->input('PaxInformationPassenger_Remaining'),
            $Request->input('PaxInformationPassenger_Status'),
            $Request->input('Id_PaxInformation'),
            $Request->input('Id_Passenger')
        ));
        $this->history->insert(
            (new PaxInformationPassengerIndexer(new MysqlPaxInformationPassengerRepository))
                ->__invoke(new IdPaxInformationPassenger($oResponse['Response_Data']['Id'])),
            $Request,
            $oResponse['Response_Data']['Id']
        );
        
        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, PaxInformationPassengerValidators::UPDATE);

        $this->history->obtainOld($Request->input('Id_PaxInformationPassenger'));

        $oResponse = (new PaxInformationPassengerUpdater(new MysqlPaxInformationPassengerRepository))->__invoke(
            new UpdatePaxInformationPassenger(
                new PaxInformationPassengerStatus($Request->input('PaxInformationPassenger_Status')),
                new IdPaxInformationPassenger($Request->input('Id_PaxInformationPassenger'))
            )
        );

        $this->history->update (
            $Request->input('Id_PaxInformationPassenger'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function Delete (Request $request, $Id) {

        $this->history->obtainOld($Id);

        $oResponse = (new PaxInformationPassengerDeleter(new MysqlPaxInformationPassengerRepository))->__invoke(new IdPaxInformationPassenger($Id));
                
        $this->history->delete (
            $Id,
            $this->history->oldValue,
            $request
        );
                
        return ResponseBuilder::Response($oResponse);
    }

    public function Index($Id) {
        $oResponse = (new PaxInformationPassengerIndexer(new MysqlPaxInformationPassengerRepository))->__invoke(new IdPaxInformationPassenger($Id));
        return ResponseBuilder::Response($oResponse);
    }

    public function List($Id_PaxInformation, $Action) {
        $oResponse = (new PaxInformationPassengerFinder(new MysqlPaxInformationPassengerRepository))->__invoke(new IdPaxInformation($Id_PaxInformation), $Action);
        return ResponseBuilder::Response($oResponse);
    }

}