<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Booking\Application\PaymentBookingEquipmentPassengerIndexer;
use App\Modules\Booking\Application\PaymentBookingEquipmentPassengerLister;
use App\Modules\Booking\Application\PaymentBookingIndexer;
use App\Modules\Booking\Application\PaymentBookingLister;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Infraestructure\MysqlPaymentBookingRepository;
use App\Modules\Booking\Infraestructure\PaymentBookingValidators;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;


class c_Payment_Booking extends Controller {

    public function __construct() {
        $this->oDomain = "Booking";
    }
        
    public function List(Request $request) {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, PaymentBookingValidators::list);
        $oResponse = (new PaymentBookingLister(new MysqlPaymentBookingRepository))->__invoke(
            $request->input('DateStart'),
            $request->input('DateEnd'),
            $request->header("Token"),
            $request->ip(),
            config('var.PATH_PUBLIC').config("var.USER_COUNTRY_THUMB")
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function ListEquipmentPassenger(Request $request) {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, PaymentBookingValidators::list);
        $oResponse = (new PaymentBookingEquipmentPassengerLister(new MysqlPaymentBookingRepository))->__invoke(
            $request->input('DateStart'),
            $request->input('DateEnd')
        );
        $response = $oResponse;
        $oResponse = (new PaymentBookingEquipmentPassengerIndexer(new MysqlPaymentBookingRepository))->__invoke(
            $request->input('DateStart'),
            $request->input('DateEnd')
        );
        $response["Response_Data"] = [
            'EquipmentPassenger' => array_reduce($response["Response_Data"], fn($carry, $response) => array_merge($carry, json_decode($response->BookingEquipment)), []),
            'BookingTourPassenger' => array_reduce($oResponse["Response_Data"], fn($carry, $response) => array_merge($carry, json_decode($response->BookingTourPassenger)), [])
        ];
        return ResponseBuilder::Response($response);
    }

    public function Index($Id, Request $request) {
        $oResponse = (new PaymentBookingIndexer(new MysqlPaymentBookingRepository))->__invoke(
            new IdBooking($Id),
            $request->header("Token"),
            $request->ip(),
            config('var.PATH_PUBLIC').config("var.USER_COUNTRY_THUMB")
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function IndexEquipmentPassenger($Id_Booking, Request $request) {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, PaymentBookingValidators::list);
        $oResponse = (new PaymentBookingEquipmentPassengerIndexer(new MysqlPaymentBookingRepository))->__invoke(
            $request->input('DateStart'),
            $request->input('DateEnd')
        );
        return ResponseBuilder::Response($oResponse);
    }

}