<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Question\Application\QuestionInserter;
use App\Modules\Question\Application\QuestionUpdater;
use App\Modules\Question\Domain\IdQuestion;
use App\Modules\Question\Domain\IdTypeProvider;
use App\Modules\Question\Domain\Question;
use App\Modules\Question\Domain\QuestionAbrv;
use App\Modules\Question\Domain\QuestionGeneral;
use App\Modules\Question\Domain\QuestionName;
use App\Modules\Question\Domain\QuestionRepository;
use App\Modules\Question\Domain\QuestionStatus;
use App\Modules\Question\Domain\QuestionType;
use App\Modules\Question\Domain\QuestionValues;
use App\Modules\Question\Domain\QuestionWeight;
use App\Modules\Question\Infraestructure\MysqlQuestionRepository;
use App\Modules\Question\Infraestructure\QuestionValidators;
use Illuminate\Support\Facades\DB;

class c_Question extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;
	private QuestionRepository $repository;

	public function __construct()
	{
		$this->oDomain = "Question";
		$this->history = new HistoryData (HistoryTables::question);
		$this->repository = new MysqlQuestionRepository();
	}

	public function Insert(Request $Request)
	{
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, QuestionValidators::insert, $this->oDomain);
		if ($oResponse["Response_Code"] != 200) {
			return ResponseBuilder::Response($oResponse);
		}
		$all = $Request->all();
		$all['Question_Values'] = json_encode($all['Question_Values']);
		$oResponse = ParamsValidator::Validate_Data($all, QuestionValidators::valuesValidator, $this->oDomain);
		if ($oResponse["Response_Code"] != 200) {
			return ResponseBuilder::Response($oResponse);
		}

		$oData = (new QuestionInserter($this->repository))->__invoke(
			new Question(
				new QuestionName(Str::title( $Request->input("Question_Name"))),
				new QuestionAbrv(Str::upper( $Request->input("Question_Abrv"))),
                new QuestionType($Request->input("Question_Type")),
                new QuestionValues($Request->input("Question_Values")),
                new QuestionWeight($Request->input("Question_Weight")),
                new QuestionGeneral($Request->input("Question_General")),
                new QuestionStatus($Request->input("Question_Status")),
                new IdTypeProvider($Request->input('Id_TypeProvider')),
            )
        );

        $data = null;

        //  RESPONSE
        if ($oData[0]->Response_Success == 1) {
            #region HISTORY EXEC
            $this->history->insertBasic ($Request);
            #endregion
            $data = [ "Id" => $oData[0]->Response_Id ];
        } else {
			
		}
		
		$oResponse["Response_Status"]			= $oData[0]->Response_Status;
		$oResponse["Response_Code"]				= $oData[0]->Response_Code;
		$oResponse["Response_Domain"]			= $this->oDomain;
		$oResponse["Response_Message"]			= $oData[0]->Response_Message;
		$oResponse["Response_Data"]				= $data;
		$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
		$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		
		return ResponseBuilder::Response($oResponse);
		
	}

	public function Update(Request $Request){
		$oResponse  = array();
		$oResponse = ParamsValidator::Validate_Request($Request, QuestionValidators::update, $this->oDomain);

		if ($oResponse["Response_Code"] != 200) {
			return ResponseBuilder::Response($oResponse);
		}
		$all = $Request->all();
		$all['Question_Values'] = json_encode($all['Question_Values']);
		$oResponse = ParamsValidator::Validate_Data($all, QuestionValidators::valuesValidator, $this->oDomain);
		if ($oResponse["Response_Code"] != 200) {
			return ResponseBuilder::Response($oResponse);
		}
		
		#region HISTORY VARIABLES
		$this->history->obtainOld($Request->input('Id_Question'));
		#endregion
		
		$oData = (new QuestionUpdater($this->repository))->__invoke(
			new Question(
				new QuestionName(Str::title( $Request->input("Question_Name"))),
				new QuestionAbrv(Str::upper( $Request->input("Question_Abrv"))),
				new QuestionType($Request->input("Question_Type")),
				new QuestionValues($Request->input("Question_Values")),
                new QuestionWeight($Request->input("Question_Weight")),
                new QuestionGeneral($Request->input("Question_General")),
				new QuestionStatus($Request->input("Question_Status")),
				new IdTypeProvider($Request->input('Id_TypeProvider')),
				new IdQuestion($Request->input('Id_Question'))
			)
		);

		if ($oData[0]->Response_Success == 1) {
			#region HISTORY EXEC
			$this->history->updateBasic ( $Request->input("Id_Question"), $Request );
			#endregion
		}
		
		$oResponse["Response_Status"]			= $oData[0]->Response_Status;
		$oResponse["Response_Code"]				= $oData[0]->Response_Code;
		$oResponse["Response_Domain"]			= $this->oDomain;
		$oResponse["Response_Message"]			= $oData[0]->Response_Message;
		$oResponse["Response_Data"]				= null;
		$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
		$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			#region HISTORY
			$this->history->obtainOld($Id);
			#endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_question_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_question_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id );
			$oData  = DB::select('call sp_question_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	public function Selector(Request $Request,$Id){
		if( is_numeric($Id) ){
			return SELF::Index( $Request,$Id );
		}else{
			return SELF::List( $Request,$Id );
		}
	}
	
	
}