<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Tour extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Tour";
        $this->history = new HistoryData(HistoryTables::tour);
    }

    public function Insert(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Tour_Code'                 => 'required|string|max:50',
                                'Tour_Name'                 => 'required|string|max:250',
                                'Tour_Duration'             => 'required|int',
                                'Tour_MinPax'               => 'required|int',
                                'Tour_Availability'         => 'required|int',
                                'Tour_AvailabilityStatus'   => 'required|int',
                                'Tour_Anticipation'         => 'required|int',
                                'Tour_AnticipationType'     => 'required|int',
                                'Tour_Color'                => 'required|string',
                                'Tour_Status'               => 'required|int',
                                'Id_CategoryTour'           => 'required|int',
                                'Id_TypeTour'               => 'required|int',
                                'Id_Country'                => 'required|int',
                                'Id_State'                  => 'required|int',
                                'Id_City'                   => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                trim(Str::upper($Request->input("Tour_Code"))),
                trim($Request->input("Tour_Name")),
                $Request->input("Tour_UrlThumbnail"),
                $Request->input("Tour_Duration"),
                $Request->input("Tour_MinPax"),
                $Request->input("Tour_Availability"),
                $Request->input("Tour_AvailabilityStatus"),
                $Request->input("Tour_Anticipation"),
                $Request->input("Tour_AnticipationType"),
                $Request->input("Tour_Color"),
                $Request->input("Tour_Status"),
                $Request->input("Id_CategoryTour"),
                $Request->input("Id_TypeTour"),
                $Request->input("Id_Country"),
                $Request->input("Id_State"),
                $Request->input("Id_City")
            ];
            $oData = DB::select('call sp_tour_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);

            $data = null;
            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->insertBasic($Request);
                #endregion
                $data = [ 'Id' => $oData[0]->Response_Id ];
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
        
    }

    public function Update(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Id_Tour'                   => 'required|int',
                                'Tour_Code'                 => 'required|string|max:50',
                                'Tour_Name'                 => 'required|string|max:250',
                                'Tour_Duration'             => 'required|int',
                                'Tour_MinPax'               => 'required|int',
                                'Tour_Availability'         => 'required|int',
                                'Tour_AvailabilityStatus'   => 'required|int',
                                'Tour_Anticipation'         => 'required|int',
                                'Tour_AnticipationType'     => 'required|int',
                                'Tour_Color'                => 'required|string',
                                'Tour_Status'               => 'required|int',
                                'Id_CategoryTour'           => 'required|int',
                                'Id_TypeTour'               => 'required|int',
                                'Id_Country'                => 'required|int',
                                'Id_State'                  => 'required|int',
                                'Id_City'                   => 'required|int'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_Tour'));
            #endregion

            $oParam = array(                $Request->input("Id_Tour"),
                                Str::upper( $Request->input("Tour_Code")),
                                Str::title( $Request->input("Tour_Name")),                              
                                            $Request->input("Tour_Duration"),
                                            $Request->input("Tour_MinPax"),
                                            $Request->input("Tour_Availability"),
                                            $Request->input("Tour_AvailabilityStatus"),
                                            $Request->input("Tour_Anticipation"),
                                            $Request->input("Tour_AnticipationType"),
                                            $Request->input("Tour_Color"),
                                            $Request->input("Tour_Status"),
                                            $Request->input("Id_CategoryTour"),
                                            $Request->input("Id_TypeTour"),
                                            $Request->input("Id_Country"),
                                            $Request->input("Id_State"),
                                            $Request->input("Id_City")
                            );
            $oData = DB::select('call sp_tour_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic ( $Request->input("Id_Tour"), $Request );
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function Delete(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            $oParam = array( $Id );
            $oData  = DB::select('call sp_tour_delete(?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic ($Id, $Request);
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_tour_index(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function list(Request $Request, $Id)
    {
        $oResponse  = array();
        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_tour_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }
        return ResponseBuilder::Response($oResponse);
    }
        
    public function ListCategory(Request $Request, $Id){
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                $Id,
                'active'
            );
            $oData  = DB::select('call sp_tour_list_category(?,?)',$oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Report(Request $Request){
        $oResponse  = array();

            $oParam = array();
            $oData  = DB::select('call sp_tour_report()',$oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." report";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        

        return ResponseBuilder::Response($oResponse);
    }
        
        
    public function selector(Request $Request, $Id)
    {
        if (is_numeric($Id)) {
            return self::Index($Request, $Id);
        } elseif ($Id == "report") {
            return self::Report($Request);
        } else {
            return $this->list($Request, $Id);
        }
    }


    public function Availability(Request $Request){
        $oResponse      = array();
        $oValParams     = array(    'Id_tour'       => 'required|int',
                                    'Date'          => 'required|string'
                                );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array(    $Request->input("Id_tour"),                         
                                $Request->input("Date"),

            );
            $oData  = DB::select('call sp_tour_availability(?,?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
        
}