<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Intervention\Image\ImageManagerStatic as Image;

class c_Tour_Extra extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Tour Extra";
		$this->history = new HistoryData (HistoryTables::tour_extra);
	}

	public function Insert(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'TourExtra_Select'		=> 'required|int',
								'TourExtra_Day'		    => 'required|int',
								'TourExtra_RequireDay'  => 'required|int',
								'TourExtra_Status'		=> 'required|int',
								'Id_TourExtraType'		=> 'required|int',
								'Id_Extra'				=> 'required|int',
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(    $Request->input("TourExtra_Select"),
								$Request->input("TourExtra_Day"),
								$Request->input("TourExtra_RequireDay"),
								$Request->input("TourExtra_Status"),
								$Request->input("Id_TourExtraType"),
								$Request->input("Id_Extra")
							);
			$oData = DB::select('call sp_tour_extra_insert(?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->insertBasic ($Request);
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_TourExtra'		=> 'required|int',
								'TourExtra_Order'	=> 'required|int',
								'TourExtra_Select'	=> 'required|int',
								'TourExtra_Day'		=> 'required|int',
								'TourExtra_RequireDay'=> 'required|int',
								'TourExtra_Status'	=> 'required|int',
								'Id_TourExtraType'	=> 'required|int',
								'Id_Extra'	        => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			#region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_TourExtra'));
			#endregion

			$oParam = array(    $Request->input("Id_TourExtra"),
								$Request->input("TourExtra_Order"),
								$Request->input("TourExtra_Select"),
								$Request->input("TourExtra_Day"),
								$Request->input("TourExtra_RequireDay"),
								$Request->input("TourExtra_Status"),
								$Request->input("Id_TourExtraType"),
								$Request->input("Id_Extra")
							);
			$oData = DB::select('call sp_tour_extra_update(?,?,?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_TourExtra"), $Request );
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			#region HISTORY
			$this->history->obtainOld($Id);
			#endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_tour_extra_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_tour_extra_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_TourExtraType, $Id){
		$oResponse  = array();
		
		$oResponse = ParamsValidator::Validate_Id($Id_TourExtraType,$this->oDomain);
		
		if ($oResponse["Response_Code"] == 200) {
			$oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

			if ($oResponse["Response_Code"] == 200) {
				$oParam = array( $Id, $Id_TourExtraType );
				$oData  = DB::select('call sp_tour_extra_list(?,?)',$oParam);

				$oResponse["Response_Status"]			= 200;
				$oResponse["Response_Code"]				= 200;
				$oResponse["Response_Domain"]			= $this->oDomain;
				$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
				$oResponse["Response_Data"]				= $oData;
				$oResponse["Response_Error_Message"]	= "";
				$oResponse["Response_Error_Reason"]		= "";
			}
		}
		return ResponseBuilder::Response($oResponse);
	}

	
}