<?php
namespace App\Http\Helpers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ParamsValidator
{
    public static function Validate_Data($data, array $Params, string $Domain){
        $oResponse  = array();
        $oValidator = Validator::make($data, $Params);

        if (!$oValidator->fails()) {
            $oResponse["Response_Status"]			= 200;
            $oResponse["Response_Code"]				= 200;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= null;
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= null;
            $oResponse["Response_Error_Reason"]		= null;
        }else{
            $oResponse["Response_Status"]			= 400;
            $oResponse["Response_Code"]				= 400;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= "Error in the input variables.";
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= "Some variables are empty or not formatted correctly.";
            $oResponse["Response_Error_Reason"]		= $oValidator->errors();            
        }

        return $oResponse;
    }
    public static function Validate_Request(Request $Request,array $Params, string $Domain){
        $oResponse  = array();
        $oValidator = Validator::make($Request->all(), $Params);

        if (!$oValidator->fails()) {
            $oResponse["Response_Status"]			= 200;
            $oResponse["Response_Code"]				= 200;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= null;
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= null;
            $oResponse["Response_Error_Reason"]		= null;
        }else{
            $oResponse["Response_Status"]			= 400;
            $oResponse["Response_Code"]				= 400;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= "Error in the input variables.";
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= "Some variables are empty or not formatted correctly.";
            $oResponse["Response_Error_Reason"]		= $oValidator->errors();            
        }

        return $oResponse;
    }
    public static function Validate_Id(int $Id, string $Domain){
        $oResponse  = array();

        if ( is_numeric($Id) == true ) {
            $oResponse["Response_Status"]			= 200;
            $oResponse["Response_Code"]				= 200;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= null;
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= null;
            $oResponse["Response_Error_Reason"]		= null;
        }else{
            $oResponse["Response_Status"]			= 400;
            $oResponse["Response_Code"]				= 400;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= "Invalid Parameter";
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= "Invalid Parameter.";
            $oResponse["Response_Error_Reason"]		= "Identifier is not a number";
        }

        return $oResponse;
    }
    public static function Validate_Action(string $Action, string $Domain)
    {
        if ($Action == "all" ||
            $Action == "active" ||
            $Action == "confirmed" ||
            $Action == "pending" ||
            $Action == "flight" ||
            $Action == "room" ||
            $Action == "search" ||
            $Action == "ongoing" ||
            $Action == "upgrade" ||
            $Action == "extra" ||
            $Action == "equipment" ||
            $Action == "finished" ||
            $Action == "content"
        ) {
            $oResponse["Response_Status"]			= 200;
            $oResponse["Response_Code"]				= 200;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= null;
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= null;
            $oResponse["Response_Error_Reason"]		= null;
        }else{
            $oResponse["Response_Status"]			= 400;
            $oResponse["Response_Code"]				= 400;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= "Invalid Parameter";
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= "Invalid Parameter.";
            $oResponse["Response_Error_Reason"]		= "Action parameter not valid";
        }

        return $oResponse;
    }
    public static function Validate_Token(string $Token, string $Domain){
        if($Token != "" ){
            $oResponse["Response_Status"]			= 200;
            $oResponse["Response_Code"]				= 200;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= null;
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= null;
            $oResponse["Response_Error_Reason"]		= null;
        }else{
            $oResponse["Response_Status"]			= 400;
            $oResponse["Response_Code"]				= 400;
            $oResponse["Response_Domain"]			= $Domain;
            $oResponse["Response_Message"]			= "Invalid Parameter";
            $oResponse["Response_Data"]				= null;
            $oResponse["Response_Error_Message"]	= "Invalid Parameter.";
            $oResponse["Response_Error_Reason"]		= "Token parameter not valid";
        }

        return $oResponse;
    }
}