<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class c_Mail_User extends Mailable
{
	use Queueable, SerializesModels;

	public $Type;
	public $Subject;
	public $Content;
	public $Pdf;
	public $PdfName = 'Resume.pdf';
	public $ReplyToValues = '';
	
	public function __construct()
	{
	}

	public function build()
	{
		if ($this->Type == 1) {
			return 	$this->view('Mail_Body.v_User_Password_Send')
						->subject($this->Subject)
						->with($this->Content);
		} else if ($this->Type == 2) {
			return 	$this->view('Mail_Body.v_User_Review')
						->subject($this->Subject)
						->with($this->Content);
		} else if ($this->Type == 3) {
			return 	$this->view('Mail_Body.v_User_Booking')
						->subject($this->Subject)
						->with($this->Content)
						->replyTo($this->ReplyToValues)
						->attachData($this->Pdf, $this->PdfName, [
							'mime' => 'application/pdf',
						]);
		} else if ($this->Type == 5) {
			return 	$this->view('Mail_Body.v_User_Review_Report')
				->subject($this->Subject)
				->with($this->Content); 
		} else {
			return 	$this->view('Mail_Body.v_User_Password_Recover')
				->subject($this->Subject)
				->with($this->Content); 
		}
		
	}
}