<?php

namespace App\Modules\Admin\Domain;

use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

class Lead
{

    /** constructor */
    public function __construct(
        private LeadName $name,
        private LeadLastName $lastName,
        private LeadGender $gender,
        private LeadEmail $email,
        private LeadPhoneCode $phoneCode,
        private LeadPhone $phone,
        private LeadNoDocument $noDocument,
        private LeadAddress $address,
        private LeadContactName $contactName,
        private LeadContactPhone $contactPhone,
        private LeadType $type,
        private LeadStatus $status,
        private IdTypeDocument $idTypeDocument,
        private IdUserCountry $idUserCountry,
        private ?IdLead $id = null
    ) {
    }
    public function getName(): LeadName
    {
        return $this->name;
    }
    public function getLastName(): LeadLastName
    {
        return $this->lastName;
    }
    public function getGender(): LeadGender
    {
        return $this->gender;
    }
    public function getEmail(): LeadEmail
    {
        return $this->email;
    }
    public function getPhoneCode(): LeadPhoneCode
    {
        return $this->phoneCode;
    }
    public function getPhone(): LeadPhone
    {
        return $this->phone;
    }
    public function getNoDocument(): LeadNoDocument
    {
        return $this->noDocument;
    }
    public function getAddress(): LeadAddress
    {
        return $this->address;
    }
    public function getContactName(): LeadContactName
    {
        return $this->contactName;
    }
    public function getContactPhone(): LeadContactPhone
    {
        return $this->contactPhone;
    }
    public function getType(): LeadType
    {
        return $this->type;
    }
    public function getStatus(): LeadStatus
    {
        return $this->status;
    }
    public function getIdTypeDocument(): IdTypeDocument
    {
        return $this->idTypeDocument;
    }
    public function getIdUserCountry(): IdUserCountry
    {
        return $this->idUserCountry;
    }
    public function getId(): IdLead
    {
        return $this->id;
    }
}
