<?php

namespace App\Modules\BookingRelationship\Domain;

class BookingRelationship {

    private BookingRelationshipName $name;
    private BookingRelationshipAbrv $abrv;
    private BookingRelationshipLock $lock;
    private BookingRelationshipStatus $status;
    private ?IdBookingRelationship $id;

    /** constructor */
    public function __construct (
        BookingRelationshipName $name,
        BookingRelationshipAbrv $abrv,
        BookingRelationshipLock $lock,
        BookingRelationshipStatus $status,
        ?IdBookingRelationship $id = NULL
    ) {
        $this->name = $name;
        $this->abrv = $abrv;
        $this->lock = $lock;
        $this->status = $status;
        $this->id = $id;
    }


    public function getName():BookingRelationshipName { return $this->name; }
    public function getAbrv():BookingRelationshipAbrv { return $this->abrv; }
    public function getLock():BookingRelationshipLock { return $this->lock; }
    public function getStatus():BookingRelationshipStatus { return $this->status; }
    public function getId():IdBookingRelationship { return $this->id; }
}