<?php

namespace App\Modules\CashMovement\Domain;

use App\Modules\TypePayment\Domain\IdTypePayment;

final class UpdateCashMovement
{
    public function __construct(
        private IdCashMovement $idCashMovement,
        private CashMovementName $cashMovementName,
        private CashMovementLastName $cashMovementLastName,
        private CashMovementEmail $cashMovementEmail,
        private CashMovementCountry $cashMovementCountry,
        private CashMovementCity $cashMovementCity,
        private CashMovementAddress $cashMovementAddress,
        private CashMovementReceiptNumber $cashMovementReceiptNumber,
        private CashMovementCardNumber $cashMovementCardNumber,
        private CashMovementCardIssuer $cashMovementCardIssuer,
        private CashMovementRemark $cashMovementRemark,
        private IdTypePayment $idTypePayment
    ) {
    }

    public function getIdCashMovement(): IdCashMovement
    {
        return $this->idCashMovement;
    }

    public function getCashMovementName(): CashMovementName
    {
        return $this->cashMovementName;
    }

    public function getCashMovementLastName(): CashMovementLastName
    {
        return $this->cashMovementLastName;
    }

    public function getCashMovementEmail(): CashMovementEmail
    {
        return $this->cashMovementEmail;
    }

    public function getCashMovementCountry(): CashMovementCountry
    {
        return $this->cashMovementCountry;
    }

    public function getCashMovementCity(): CashMovementCity
    {
        return $this->cashMovementCity;
    }

    public function getCashMovementAddress(): CashMovementAddress
    {
        return $this->cashMovementAddress;
    }

    public function getCashMovementReceiptNumber(): CashMovementReceiptNumber
    {
        return $this->cashMovementReceiptNumber;
    }

    public function getCashMovementCardNumber(): CashMovementCardNumber
    {
        return $this->cashMovementCardNumber;
    }

    public function getCashMovementCardIssuer(): CashMovementCardIssuer
    {
        return $this->cashMovementCardIssuer;
    }

    public function getCashMovementRemark(): CashMovementRemark
    {
        return $this->cashMovementRemark;
    }

    public function getIdTypePayment(): IdTypePayment
    {
        return $this->idTypePayment;
    }
}
