<?php

namespace App\Modules\External\Infraestructure;

use App\Modules\External\Domain\HCHtlUsageDateUsage;
use App\Modules\External\Domain\External;
use App\Modules\External\Domain\ExternalRepository;
use App\Modules\External\Domain\IdExternal;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlExternalRepository implements ExternalRepository
{

    public function find(string $query, string $action, string $path)
    {
        return Requester::requestSelect(
            'CALL sp_external_list(?,?,?,@sts,@cod,@msg)',
            [
                $query,
                $action,
                $path
            ]
        );
    }

    public function index(IdExternal $id)
    {
        return Requester::requestSelect(
            'CALL sp_external_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(External $value)
    {
        return Requester::requestInsert(
            'CALL sp_external_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getName()->value(),
                $value->getAbrv()->value(),
                $value->getAsset()->value(),
                $value->getLock()->value(),
                $value->getStatus()->value(),
            ]
        );
    }

    public function update(External $value)
    {
        return Requester::requestUpdate(
            'CALL sp_external_update(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getName()->value(),
                $value->getAbrv()->value(),
                $value->getAsset()->value(),
                $value->getStatus()->value(),
            ]
        );
    }

    public function delete(IdExternal $id)
    {
        return Requester::requestUpdate(
            'CALL sp_external_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
