<?php

namespace App\Modules\ExternalReview\Infraestructure;

class ExternalReviewValidators
{

    public const INSERT = [
        'ExternalUser_NickName'         => 'string|max:250',
        'ExternalUser_Name'             => 'required|string|max:250',
        'ExternalReview_DateReview'     => 'required|string',
        'ExternalReview_Route'          => 'string|max:250',
        'ExternalReview_Title'          => 'string|max:250',
        'ExternalReview_Value'          => 'string|max:5000',
        'ExternalReview_Score'          => 'required|int',
        'ExternalReview_Type'           => 'required|int',
        'ExternalReview_Status'         => 'required|int',
        'Id_ExternalUser'               => 'required|int',
        'Id_GroupPassenger'             => 'required|int',
        'Id_BookingRelationship'        => 'required|int',
        'Id_Language'                   => 'required|int',
        'Id_External'                   => 'required|int',
        'Id_Admin'                      => 'required|int',
        'Id_ExternalReview_Parent'      => 'required|int',
        'ExternalReviewProvider'        => 'required|string'
    ];

    public const GROUP_PROVIDER = [
        'ExternalReviewProvider.*.Id_GroupProvider' => 'required|int',
        'ExternalReviewProvider.*.ExternalReviewProvider_Type' => 'required|int',
    ];

    public const UPDATE_GROUP_PROVIDER = [
        'ExternalReviewProvider.*.ExternalReviewProvider_Type' => 'required|int',
        'ExternalReviewProvider.*.ExternalReviewProvider_Status' => 'required|int',
        'ExternalReviewProvider.*.Id_ExternalReview' => 'required|int',
        'ExternalReviewProvider.*.Id_GroupProvider' => 'required|int',
        'ExternalReviewProvider.*.Id_ExternalReviewProvider' => 'required|int',
    ];

    public const UPDATE = [
        'Id_ExternalReview'             => 'required|int',
        'ExternalUser_NickName'         => 'string|max:250',
        'ExternalUser_Name'             => 'required|string|max:250',
        'ExternalReview_DateReview'     => 'required|string',
        'ExternalReview_Route'          => 'string|max:250',
        'ExternalReview_Title'          => 'string|max:250',
        'ExternalReview_Value'          => 'string|max:5000',
        'ExternalReview_Score'          => 'required|int',
        'ExternalReview_Type'           => 'required|int',
        'ExternalReview_Status'         => 'required|int',
        'Id_ExternalUser'               => 'required|int',
        'Id_GroupPassenger'             => 'required|int',
        'Id_BookingRelationship'        => 'required|int',
        'Id_Language'                   => 'required|int',
        'Id_External'                   => 'required|int',
        'Id_Admin'                      => 'required|int',
        'Id_ExternalReview_Parent'      => 'required|int',
        'ExternalReviewProvider'        => 'required|string'
    ];

    public const FIND = [
        'DateStart'                     => 'required|string|date',
        'DateEnd'                       => 'required|string|date'
    ];
}
