<?php

namespace App\Modules\ExternalUser\Domain;

use App\Modules\External\Domain\IdExternal;

class ExternalUser
{

    /** constructor */
    public function __construct(
        private ExternalUserName $name,
        private ExternalUserLastName $lastName,
        private ExternalUserNickName $nickName,
        private ExternalUserGender $gender,
        private ExternalUserStatus $status,
        private IdExternal $idExternal,
        private ?IdExternalUser $id = null
    ) {
    }

    public function getName():ExternalUserName
    {
        return $this->name;
    }
    public function getLastName():ExternalUserLastName
    {
        return $this->lastName;
    }
    public function getNickName():ExternalUserNickName
    {
        return $this->nickName;
    }
    public function getGender():ExternalUserGender
    {
        return $this->gender;
    }
    public function getStatus():ExternalUserStatus
    {
        return $this->status;
    }
    public function getIdExternal():IdExternal
    {
        return $this->idExternal;
    }
    public function getId():IdExternalUser
    {
        return $this->id;
    }
}
