<?php

namespace App\Modules\Group\Application\Report;

final class ReportGroupResponseConverter {

    public function __invoke(array $modelList): array {
        return array_map (
            fn($model) => new ReportGroupResponse(
                $model->Id_Group,
                $model->Group_DateStart,
                $model->Group_DateEnd,
                $model->Group_Hour,
                $model->Group_Name,
                $model->Group_Origin,
                $model->Group_Destination,
                $model->Group_Type,
                $model->Group_TourDuration,
                $model->Group_Remark,
                $model->Group_MasterType,
                $model->Group_ServiceType,
                $model->Group_NotificationCount,
                $model->Group_NotificationStatus,
                $model->Group_Status,
                $model->Id_Service,
                $model->Service_Code,
                $model->Service_Name,
                $model->Service_Detail,
                $model->Group_NoPassenger,
                $model->Group_Provider_JSON
            ),
            $modelList['Response_Data']
        );
    }
}
