<?php

namespace App\Modules\Group\Application\WrapReport;

class RichProviderWithJson
{
    public function __construct(
        private int $groupCount
    ) {
    }

    public function __invoke(array $providers)
    {
        $length = count($providers);
        for ($i = 0; $i < $length; $i++) {
            $providerResume = json_decode($providers[$i]->Provider_JSON);
            $real = [];
            foreach ($providerResume as $provider) {
                $hasFoundProvider = false;
                foreach ($real as $p) {
                    if ($provider->Id_Provider == $p->Id_Provider) {
                        $p->amount++;
                        $p->Group_ServiceType .= ' | ' . $provider->Group_ServiceType;
                        
                        $p->GroupProvider_Remark .= ' ' . $provider->GroupProvider_Remark;
                        $hasFoundProvider = true;
                        if ($p->amount == $this->groupCount) {
                            $p->all = true;
                        }
                    }
                }
                if (!$hasFoundProvider) {
                    $real[] = (object) [
                        'Id_Provider' => $provider->Id_Provider,
                        'provider' => $provider,
                        'Group_ServiceType' => $provider->Group_ServiceType,
                        'GroupProvider_Remark' => $provider->GroupProvider_Remark,
                        'amount' => 1,
                        'all' => $this->groupCount == 1
                    ];
                }
            }
            $group = $this->convertInDescriptionList($real);
            $providers[$i]->Provider = join("\n", $group);
        }
        return $providers;
    }

    private function convertInDescriptionList($providers)
    {
        return array_map(
            fn($prov) => $prov->provider->Provider_BusinessName .
                        ' - ' .
                        $prov->provider->Provider_Phone .
                        ($prov->provider->GroupProvider_Type == 2 ? '(ENCARGADO)' : '') .
                        ' ' .
                        ($this->shouldHideTour($prov) ? '' : '(' . $prov->Group_ServiceType . ') ') .
                        $prov->GroupProvider_Remark,
            $providers
        );
    }

    private function shouldHideTour($prov)
    {
        return $prov->all || ($prov->amount == 1 && $prov->provider->Is_Group == 1);
    }
}
