<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\Group\Domain\GroupStatus;
use App\Modules\Group\Domain\GroupStatusRepository;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Application\ActionHandler;
use Illuminate\Support\Facades\DB;

class MysqlGroupStatusRepository implements GroupStatusRepository
{

    public function __invoke(IdGroup $idGroup, GroupStatus $groupStatus)
    {
        return (new ActionHandler())->handle(DB::select(
            'call sp_group_status(?,?)',
            [
                $idGroup->getValue(),
                $groupStatus->getValue(),
            ]
        ));
    }
}
