<?php

namespace App\Modules\GroupPassenger\Application;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;

class GroupPassengerListWithReview
{
    private GroupPassengerRepository $repository;

    public function __construct(GroupPassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroup $idGroup, $path, $pathCountry)
    {
        return $this->repository->findWithReview($idGroup, $path, $pathCountry);
    }
}
