<?php

namespace App\Modules\GroupProvider\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\Provider\Domain\ProviderNoDocument;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlGroupProviderRepository implements GroupProviderRepository
{
    public function searchByDocument(IdGroup $idGroup, ProviderNoDocument $noDocument)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_search_by_document(?,?,@sts,@cod,@msg)',
            [
                $idGroup->value(),
                $noDocument->value()
            ]
        );
    }
    public function searchByDocumentOnly(ProviderNoDocument $noDocument)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_search_by_document_only(?,?,@sts,@cod,@msg)',
            [
                $idGroup->value(),
                $noDocument->value()
            ]
        );
    }
}
