<?php

namespace App\Modules\HtlCamp\Domain;

class HtlCamp {

    private HtlCampName $name;
    private HtlCampAbrv $abrv;
    private HtlCampAvailability $availability;
    private HtlCampStatus $status;
    private ?IdHtlCamp $id;


    /** constructor */
    public function __construct (
        HtlCampName $name,
        HtlCampAbrv $abrv,
        HtlCampAvailability $availability,
        HtlCampStatus $status,
        ?IdHtlCamp $id = NULL
    ) {
        $this->name = $name;
        $this->abrv = $abrv;
        $this->availability = $availability;
        $this->status = $status;
        $this->id = $id;
    }

    public function getName():HtlCampName { return $this->name; }
    public function getAbrv():HtlCampAbrv { return $this->abrv; }
    public function getAvailability():HtlCampAvailability { return $this->availability; }
    public function getStatus():HtlCampStatus { return $this->status; }
    public function getId():IdHtlCamp { return $this->id; }

}