<?php

namespace App\Modules\HtlRoom\Infraestructure;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlRoom\Domain\HtlRoom;
use App\Modules\HtlRoom\Domain\HtlRoomRepository;
use App\Modules\HtlRoom\Domain\IdHtlRoom;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlHtlRoomRepository implements HtlRoomRepository {

    public function find(IdHtlCamp $idHtlCamp, string $query, string $action) {
        return Requester::requestSelect(
            'CALL sp_htl_room_list(?,?,?,@sts,@cod,@msg)',
            [
                $idHtlCamp->getValue(),
                $query,
                $action
            ]
        );
    }

    public function index(IdHtlRoom $id) {
        return Requester::requestSelect(
            'CALL sp_htl_room_index(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

    public function insert(HtlRoom $value) {
        return Requester::requestInsert(
            'CALL sp_htl_room_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getNumber()->getValue(),
                $value->getStatus()->getValue(),
                $value->getIdHtlCamp()->getValue(),
            ]
        );
    }

    public function update(HtlRoom $value) {
        return Requester::requestUpdate(
            'CALL sp_htl_room_update(?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->getValue(),
                $value->getNumber()->getValue(),
                $value->getStatus()->getValue(),
            ]
        );
    }

    public function delete(IdHtlRoom $id) {
        return Requester::requestUpdate(
            'CALL sp_htl_room_delete(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

}
