<?php

namespace App\Modules\Lead\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadInserterQuery implements Query
{
    public function __construct(
        private string $leadName,
        private string $leadLastName,
        private int $leadGender,
        private string $leadEmail,
        private string $leadPhoneCode,
        private string $leadPhone,
        private string $leadNoDocument,
        private string $leadAddress,
        private string $leadContactName,
        private string $leadContactPhone,
        private int $leadType,
        private int $leadStatus,
        private int $idTypeDocument,
        private int $idUserCountry,
    ) {
    }

    public function getName(): string
    {
        return $this->leadName;
    }
    public function getLastName(): string
    {
        return $this->leadLastName;
    }
    public function getGender(): int
    {
        return $this->leadGender;
    }
    public function getEmail(): string
    {
        return $this->leadEmail;
    }
    public function getPhoneCode(): string
    {
        return $this->leadPhoneCode;
    }
    public function getPhone(): string
    {
        return $this->leadPhone;
    }
    public function getNoDocument(): string
    {
        return $this->leadNoDocument;
    }
    public function getAddress(): string
    {
        return $this->leadAddress;
    }
    public function getContactName(): string
    {
        return $this->leadContactName;
    }
    public function getContactPhone(): string
    {
        return $this->leadContactPhone;
    }
    public function getType(): int
    {
        return $this->leadType;
    }
    public function getStatus(): int
    {
        return $this->leadStatus;
    }
    public function getIdTypeDocument(): int
    {
        return $this->idTypeDocument;
    }
    public function getIdUserCountry(): int
    {
        return $this->idUserCountry;
    }
}
