<?php

namespace App\Modules\LeadBooking\Application\Delete;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingDeleterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingDeleter $inserter)
    {
    }

    public function __invoke(LeadBookingDeleterQuery $query): LeadBookingDeleterResponse
    {
        return $this->inserter->__invoke(new IdLeadBooking($query->getId()));
    }
}
