<?php

namespace App\Modules\LeadBooking\Application\Index;

use App\Modules\LeadBooking\Application\Index\LeadBookingIndexerResponse;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBooking\Domain\LeadBooking;
use App\Modules\LeadBooking\Domain\LeadBookingRepository;

final class LeadBookingIndexer
{
    public function __construct(private LeadBookingRepository $repository)
    {
    }

    public function __invoke(IdLeadBooking $idLeadBooking): LeadBookingIndexerResponse
    {
        return new LeadBookingIndexerResponse($this->repository->index($idLeadBooking));
    }
}
