<?php

namespace App\Modules\LeadBookingTour\Application\Delete;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourDeleterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourDeleter $inserter)
    {
    }

    public function __invoke(LeadBookingTourDeleterQuery $query): LeadBookingTourDeleterResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingTour($query->getId()));
    }
}
