<?php

namespace App\Modules\LeadBookingTour\Domain;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Tour\Domain\IdTour;

class LeadBookingTour
{

    /** constructor */
    public function __construct(
        private LeadBookingTourDateStart $dateStart,
        private LeadBookingTourPickUp $pickUp,
        private LeadBookingTourType $type,
        private LeadBookingTourNoPax $noPax,
        private LeadBookingTourGroup $group,
        private LeadBookingTourStatus $status,
        private IdLeadBooking $idLeadBooking,
        private IdPackage $idPackage,
        private IdTour $idTour,
        private ?IdLeadBookingTour $id = null
    ) {
    }
    public function getDateStart(): LeadBookingTourDateStart
    {
        return $this->dateStart;
    }
    public function getPickUp(): LeadBookingTourPickUp
    {
        return $this->pickUp;
    }
    public function getType(): LeadBookingTourType
    {
        return $this->type;
    }
    public function getNoPax(): LeadBookingTourNoPax
    {
        return $this->noPax;
    }
    public function getGroup(): LeadBookingTourGroup
    {
        return $this->group;
    }
    public function getStatus(): LeadBookingTourStatus
    {
        return $this->status;
    }
    public function getIdLeadBooking(): IdLeadBooking
    {
        return $this->idLeadBooking;
    }
    public function getIdPackage(): IdPackage
    {
        return $this->idPackage;
    }
    public function getIdTour(): IdTour
    {
        return $this->idTour;
    }
    public function getId(): IdLeadBookingTour
    {
        return $this->id;
    }
}
